function w = passeggiata_unod_pressione(v,P,theta,K)
%Funzione che prende in input un vettore colonna a valori interi positivi 
%di lunghezza almeno 3, un vettore pressione della stessa dimensione, la
%probabilità massima di moto e la carrying capacity e restituisce il vettore 
%ottenuto compiendo un passo di una passegiata secondo pressione


n=length(v);
P=min(P,K);

%NB: per usare mnrnd è fondamentale che i vettori siano colonne
prob_s=theta*subplus(P(2:n-1)-P(1:n-2))/(2*K);
prob_d=theta*subplus(P(2:n-1)-P(3:n))/(2*K);

b=mnrnd(v(2:n-1),[prob_s 1-prob_s-prob_d prob_d]);

w=[b(:,1);0;0]+[0;b(:,2);0]+[0;0;b(:,3)];

%estremi
a=binornd(v(1),theta*subplus(P(1)-P(2))/(2*K));
w(1)=w(1)+v(1)-a;
w(2)=w(2)+a;

a=binornd(v(n),theta*subplus(P(n)-P(n-1))/(2*K));
w(n)=w(n)+v(n)-a;
w(n-1)=w(n-1)+a;
